/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class NeonCactusPlantBlock
extends BaseBlockNotFull
implements SimpleWaterloggedBlock,
RenderLayerProvider,
PottablePlant {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final EnumProperty<EndBlockProperties.CactusBottom> CACTUS_BOTTOM = EndBlockProperties.CACTUS_BOTTOM;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final EnumMap<Direction, VoxelShape> BIG_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> MEDIUM_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> SMALL_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction.Axis, VoxelShape> BIG_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> MEDIUM_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> SMALL_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final int MAX_LENGTH = 12;

    public NeonCactusPlantBlock() {
        super(FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50128_).lightLevel(bs -> 15).m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE, CACTUS_BOTTOM, WATERLOGGED, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction dir = ctx.m_43719_();
        BlockState down = world.m_8055_(pos.m_121945_(dir.m_122424_()));
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)ctx.m_43719_());
        state = down.m_60713_(Blocks.f_50259_) || down.m_60713_(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (down.m_60713_(EndBlocks.END_MOSS) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal((BlockState)state, (Rotation)rotation, (Property)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal((BlockState)state, (Mirror)mirror, (Property)FACING);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        Direction dir;
        BlockState downState;
        world.m_186460_(pos, (Block)this, 2);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        state = (downState = world.m_8055_(pos.m_121945_((dir = (Direction)state.m_61143_((Property)FACING)).m_122424_()))).m_60713_(Blocks.f_50259_) || downState.m_60713_(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.m_60713_(EndBlocks.END_MOSS) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_7740_(blockPos, true, null, 1);
        }
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.m_61143_(SHAPE);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockState next = view.m_8055_(pos.m_121945_(dir));
        if (next.m_60713_((Block)this)) {
            Direction.Axis axis = dir.m_122434_();
            if (shape == BlockProperties.TripleShape.BOTTOM) {
                return BIG_SHAPES.get(axis);
            }
            return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES.get(axis) : SMALL_SHAPES.get(axis);
        }
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return BIG_SHAPES_OPEN.get(dir);
        }
        return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES_OPEN.get(dir) : SMALL_SHAPES_OPEN.get(dir);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_121945_(dir.m_122424_());
        BlockState support = level.m_8055_(supportPos);
        return support.m_60713_((Block)this) || support.m_60783_((BlockGetter)level, supportPos, dir);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction side;
        BlockPos sidePos;
        if (!this.m_7898_(state, (LevelReader)world, pos) || random.m_188503_(8) > 0) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (!world.m_46859_(pos.m_121945_(dir))) {
            return;
        }
        int length = this.getLength(state, world, pos, 12);
        if (length < 0 || length > 11) {
            return;
        }
        if (dir.m_122434_().m_122479_()) {
            int horizontal = this.getHorizontal(state, (WorldGenLevel)world, pos, 2);
            if (horizontal > random.m_188503_(2)) {
                dir = Direction.UP;
                if (!world.m_8055_(pos.m_7494_()).m_60795_()) {
                    return;
                }
            }
        } else if (length > 1 && world.m_8055_(pos.m_121945_(dir.m_122424_())).m_60713_((Block)this) && world.m_46859_(sidePos = pos.m_121945_(side = this.getSideDirection((WorldGenLevel)world, pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sidePos, (BlockState)placement);
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos.m_121945_(dir), (BlockState)placement);
        this.mutateStem(placement, (WorldGenLevel)world, pos, 12);
    }

    public void growPlant(WorldGenLevel world, BlockPos pos, RandomSource random) {
        this.growPlant(world, pos, random, MHelper.randRange((int)6, (int)12, (RandomSource)random));
    }

    public void growPlant(WorldGenLevel world, BlockPos pos, RandomSource random, int iterations) {
        BlockState state = this.m_49966_();
        BlockState downState = world.m_8055_(pos.m_7495_());
        state = downState.m_60713_(Blocks.f_50259_) || downState.m_60713_(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.m_60713_(EndBlocks.END_MOSS) ? (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        ArrayList ends = Lists.newArrayList((Object[])new BlockPos.MutableBlockPos[]{pos.m_122032_()});
        for (int i = 0; i < iterations; ++i) {
            int count = ends.size();
            for (int n = 0; n < count; ++n) {
                if (this.growIteration(world, (BlockPos.MutableBlockPos)ends.get(n), random, ends, i)) continue;
                ends.remove(n);
                --count;
                --n;
            }
        }
    }

    private boolean growIteration(WorldGenLevel world, BlockPos.MutableBlockPos pos, RandomSource random, List<BlockPos.MutableBlockPos> ends, int length) {
        Direction side;
        BlockPos sidePos;
        BlockState state = world.m_8055_((BlockPos)pos);
        if (!state.m_60713_((Block)this)) {
            return false;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (!world.m_46859_(pos.m_121945_(dir))) {
            return false;
        }
        if (dir.m_122434_().m_122479_()) {
            int horizontal = this.getHorizontal(state, world, (BlockPos)pos, 2);
            if (horizontal > random.m_188503_(2)) {
                dir = Direction.UP;
                if (!world.m_8055_(pos.m_7494_()).m_60795_()) {
                    return false;
                }
            }
        } else if (length > 1 && world.m_8055_(pos.m_7495_()).m_60713_((Block)this) && world.m_46859_(sidePos = pos.m_121945_(side = this.getSideDirection(world, (BlockPos)pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sidePos, (BlockState)placement);
            ends.add(sidePos.m_122032_());
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).m_61124_(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos.m_121945_(dir), (BlockState)placement);
        this.mutateStem(placement, world, (BlockPos)pos, 12);
        pos.m_122173_(dir);
        return true;
    }

    private Direction getSideDirection(WorldGenLevel world, BlockPos pos, BlockState iterState, Direction dir, RandomSource random) {
        Direction side;
        BlockPos.MutableBlockPos iterPos = pos.m_122032_();
        Direction startDir = dir;
        Direction lastDir = null;
        while (iterState.m_60713_((Block)this) && startDir.m_122434_().m_122478_()) {
            startDir = (Direction)iterState.m_61143_((Property)FACING);
            if (lastDir == null) {
                for (Direction side2 : BlocksHelper.HORIZONTAL) {
                    Direction sideDir;
                    BlockState sideState = world.m_8055_(iterPos.m_121945_(side2));
                    if (!sideState.m_60713_((Block)this) || (sideDir = (Direction)sideState.m_61143_((Property)FACING)) != side2) continue;
                    lastDir = sideDir;
                }
            }
            iterPos.m_122173_(dir);
            iterState = world.m_8055_((BlockPos)iterPos);
        }
        Direction direction = side = lastDir == null ? BlocksHelper.randomHorizontal((RandomSource)random) : lastDir.m_122427_();
        if (side.m_122424_() == startDir) {
            side = side.m_122424_();
        }
        return side;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        entity.m_6469_(level.m_269111_().m_269325_(), 1.0f);
    }

    private int getLength(BlockState state, ServerLevel world, BlockPos pos, int max) {
        int length = 0;
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.m_122173_(dir);
            state = world.m_8055_((BlockPos)mut);
            if (!state.m_60713_((Block)this)) {
                if (state.m_204336_(CommonBlockTags.END_STONES)) break;
                length = -1;
                break;
            }
            dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            ++length;
        }
        return length;
    }

    private int getHorizontal(BlockState state, WorldGenLevel world, BlockPos pos, int max) {
        int count = 0;
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.m_122173_(dir);
            state = world.m_8055_((BlockPos)mut);
            if (!state.m_60713_((Block)this) || (dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_()).m_122430_() != 0) break;
            ++count;
        }
        return count;
    }

    private void mutateStem(BlockState state, WorldGenLevel world, BlockPos pos, int max) {
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.m_122173_(dir);
            state = world.m_8055_((BlockPos)mut);
            if (!state.m_60713_((Block)this)) {
                return;
            }
            int size = (i + 2) * 3 / max;
            int src = ((BlockProperties.TripleShape)state.m_61143_(SHAPE)).getIndex();
            dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            if (src >= size) continue;
            BlockProperties.TripleShape shape = BlockProperties.TripleShape.fromIndex((int)size);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)shape)));
        }
    }

    @Override
    public boolean canPlantOn(Block block) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getPottedState() {
        return "bottom=moss,shape=top,facing=up";
    }

    static {
        BIG_SHAPES.put(Direction.Axis.X, Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Y, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Z, Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        MEDIUM_SHAPES.put(Direction.Axis.X, Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Y, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Z, Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
        SMALL_SHAPES.put(Direction.Axis.X, Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Y, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Z, Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.UP, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.DOWN, Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.NORTH, Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.SOUTH, Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.WEST, Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.EAST, Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        MEDIUM_SHAPES_OPEN.put(Direction.UP, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.DOWN, Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.NORTH, Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0));
        MEDIUM_SHAPES_OPEN.put(Direction.SOUTH, Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.WEST, Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.EAST, Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        SMALL_SHAPES_OPEN.put(Direction.UP, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.DOWN, Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.NORTH, Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0));
        SMALL_SHAPES_OPEN.put(Direction.SOUTH, Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.WEST, Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.EAST, Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

